<?php
/**
 * Recent post widget
 * @package automatic
 */

class WP_Automatic_Widget_Recent_Posts extends WP_Widget {

    public function __construct() {
        $widget_ops = array( 'classname' => 'automatic_widget_recent_posts', 'description' => esc_html__( "Your site&#8217;s most recent Posts.", "automatic") );
        parent::__construct( 'automatic-recent-posts', esc_html__( '[Automatic] Recent Posts', 'automatic' ), $widget_ops );
        $this->alt_option_name = 'automatic_widget_recent_posts';
    }

    public function widget( $args, $instance ) {
        $number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 3;
        if ( ! $number )
            $number = 3;
        $layout      = isset( $instance['layout'] ) ? $instance['layout'] : '1';
		$r = new WP_Query( apply_filters( 'automatic_widget_posts_args', array(
            'posts_per_page'      => $number,
            'no_found_rows'       => true,
            'post_status'         => 'publish',
            'ignore_sticky_posts' => true
        ) ) );

        if ($r->have_posts()) :
?>
        <?php echo $args['before_widget']; ?>
        <div class="shop-features">
            <?php if ( $instance['title'] ) {
                echo $args['before_title'] . esc_html($instance['title']) . $args['after_title'];
            } ?>
			<div class="automatic-recent-posts">
    			<?php if ( $layout == 1 ) : ?>
                    <div class="automatic-widget automatic-widget-blog">
                        <div class="beans-stepslider" data-rotate="true">
                            <div class="beans-mask">
                                <div class="beans-slideset">
                                    <?php
                                        while ( $r->have_posts() ) : $r->the_post();
                                    ?>
                                        <div class="beans-slide">
                                            <?php if ( has_post_thumbnail() ) : ?>
                                               <?php the_post_thumbnail();?>
                                            <?php endif; ?>
                                            <div class="txt">
                                                <a class="" href="<?php the_permalink(); ?>">
                                                    <?php the_title(); ?>
                                                </a>
                                                <?php the_content('');?>
                                                <div class="automatic-date">
                                                    <span class="item-time left"><?php echo get_the_time( 'M d Y',get_the_ID() ); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    <?php
                                        endwhile;
                                        wp_reset_postdata();
                                    ?>
                                </div>
                            </div>
                            <div class="beans-pagination">
                                <!-- pagination generated here -->
                            </div>
                        </div>
                    </div>
                <?php
                endif;
                if ( $layout == 2 ) :
                    while ( $r->have_posts() ) : $r->the_post();
                        ?>
        				<div class="item-news  layout2">
                            <div class="row">
                                <div class="col-md-4 col-xs-4 col-sm-4 recent-post-thumbnail">
                                    <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('automatic-image-product-xsmall'); ?></a>
                                </div>
            					<div class="col-md-8 col-xs-8 col-sm-8 txt">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php the_title(); ?>
                                    </a>
                                    <span class="item-time"><?php echo get_the_time( 'M d Y',get_the_ID() ); ?></span>
            					</div>
                            </div>
        				</div>
        			<?php
                    endwhile;
                    wp_reset_postdata();
                endif;
             ?>
			</div>
        </div>
        <?php echo $args['after_widget']; ?>
<?php
        endif;
    }

    /*Update data widget*/
    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = $new_instance['title'];
        $instance['number'] = (int) $new_instance['number'];
        $instance['layout'] = strip_tags($new_instance['layout']);
        return $instance;
    }

    /*Layout admin widget*/
    public function form( $instance ) {
        $title              = isset( $instance['title'] ) ? wp_kses($instance['title'],array('span'=>array('class'=>array()))) : '';
        $number             = isset( $instance['number'] ) ? absint( $instance['number'] ) : 2;
        $layout          = isset( $instance['layout'] ) ?  esc_html( $instance['layout'] ) : '1';
        ?>
        <p><label for="<?php echo  esc_html($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:','automatic' ); ?></label>
        <input class="widefat" id="<?php echo  esc_html($this->get_field_id( 'title' )); ?>" name="<?php echo  esc_html($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo  esc_html($title); ?>" /></p>

        <p><label for="<?php echo  esc_html($this->get_field_id( 'number' )); ?>"><?php esc_html_e( 'Number of posts to show:', 'automatic' ); ?></label>
        <input id="<?php echo  esc_html($this->get_field_id( 'number' )); ?>" name="<?php echo  esc_html($this->get_field_name( 'number' )); ?>" type="text" value="<?php echo  esc_html($number); ?>" size="3" /></p>
        <p><select name="<?php echo  esc_html($this->get_field_name( 'layout' )); ?>">
                <option value="1" <?php selected( $layout, '1');?>><?php esc_html_e('Type 1','automatic')?></option>
                <option value="2" <?php selected( $layout, '2');?>><?php esc_html_e('Type 2','automatic')?></option>
            </select>
        <label for="<?php echo  esc_html($this->get_field_id( 'layout' )); ?>"><?php esc_html_e( 'Select type of show', 'automatic' ); ?></label></p>
        <?php
    }
}